#!/bin/bash

s=bdl
t=slt

mode=melspc_r3

out_dir=exp/vtn/${mode}/${s}_to_${t}
mkdir -p ${out_dir}

n_gpu=1
export CUDA_VISIBLE_DEVICES=0

../../../tools/venv/bin/python3 \
    ../../../espnet2/bin/vc_train.py \
    --use_preprocessor false \
    --normalize global_mvn \
    --s_normalize global_mvn \
    --resume true \
    --output_dir ${out_dir} \
    --config conf/tuning/train_transformer_vc_${mode}.yaml \
    --feats_s_extract fbank \
    --feats_s_extract_conf n_fft=1024 \
    --feats_s_extract_conf hop_length=256 \
    --feats_s_extract_conf win_length=null \
    --feats_s_extract_conf fs=24000 \
    --feats_s_extract_conf fmin=80 \
    --feats_s_extract_conf fmax=7600 \
    --feats_s_extract_conf n_mels=80 \
    --feats_extract fbank \
    --feats_extract_conf n_fft=1024 \
    --feats_extract_conf hop_length=256 \
    --feats_extract_conf win_length=null \
    --feats_extract_conf fs=24000 \
    --feats_extract_conf fmin=80 \
    --feats_extract_conf fmax=7600 \
    --feats_extract_conf n_mels=80 \
    --train_data_path_and_name_and_type dump/raw/${s}_train_no_dev/wav.scp,speech_s,sound \
    --train_data_path_and_name_and_type dump/raw/${t}_train_no_dev/wav.scp,speech,sound \
    --train_shape_file stats/jets/${s}/tts_stats_raw_phn_tacotron_g2p_en_no_space/train/speech_s_shape \
    --train_shape_file stats/jets/${t}/tts_stats_raw_phn_tacotron_g2p_en_no_space/train/speech_shape \
    --valid_data_path_and_name_and_type dump/raw/${s}_dev/wav.scp,speech_s,sound \
    --valid_data_path_and_name_and_type dump/raw/${t}_dev/wav.scp,speech,sound \
    --valid_shape_file stats/jets/${s}/tts_stats_raw_phn_tacotron_g2p_en_no_space/valid/speech_s_shape \
    --valid_shape_file stats/jets/${t}/tts_stats_raw_phn_tacotron_g2p_en_no_space/valid/speech_shape \
    --s_normalize_conf stats_file=stats/jets/${s}/tts_stats_raw_phn_tacotron_g2p_en_no_space/train/feats_stats.npz \
    --normalize_conf stats_file=stats/jets/${t}/tts_stats_raw_phn_tacotron_g2p_en_no_space/train/feats_stats.npz \
    --ngpu ${n_gpu} \
    --multiprocessing_distributed True \
    2>&1 | tee ${out_dir}/train.log
