#!/usr/bin/env bash
# Set bash to 'debug' mode, it will exit on :
# -e 'error', -u 'undefined variable', -o ... 'error in pipeline', -x 'print commands',
set -e
set -u
set -o pipefail

fs=24000
n_fft=1024
n_shift=256

opts="--audio_format wav "

train_set=bdl_train_no_dev
valid_set=bdl_dev
test_sets=bdl_eval

train_config=conf/tuning/train_jets.yaml
inference_config=

#n_gpus=4
#export CUDA_VISIBLE_DEVICES=0,1,2,3

# g2p=g2p_en # Include word separator
g2p=g2p_en_no_space # Include no word separator

#opts+="--write_collected_feats true"

./tts.sh \
    --stage 4 \
    --stop_stage 4 \
    --lang en \
    --feats_type raw \
    --token_type phn \
    --cleaner tacotron \
    --g2p "${g2p}" \
    --train_set "${train_set}" \
    --valid_set "${valid_set}" \
    --test_sets "${test_sets}" \
    --srctexts "data/${train_set}/text" \
    --tts_task gan_tts
