#!/usr/bin/env bash
# Set bash to 'debug' mode, it will exit on :
# -e 'error', -u 'undefined variable', -o ... 'error in pipeline', -x 'print commands',
set -e
set -u
set -o pipefail

method=vits
spk=slt

fs=24000
n_fft=1024
n_shift=256

opts="--audio_format wav "

train_set=${spk}_train_no_dev
valid_set=${spk}_dev
test_sets=${spk}_eval

train_config=conf/tuning/train_${method}.yaml
inference_config=

n_gpus=4
export CUDA_VISIBLE_DEVICES=0,1,2,3

# g2p=g2p_en # Include word separator
g2p=g2p_en_no_space # Include no word separator

opts+="--write_collected_feats true"

./tts.sh \
    --feats_extract linear_spectrogram \
    --inference_model latest.pth \
    --stage 5 \
    --stop_stage 5 \
    --expdir stats/${method}/${spk} \
    --lang en \
    --feats_type raw \
    --fs "${fs}" \
    --n_fft "${n_fft}" \
    --n_shift "${n_shift}" \
    --token_type phn \
    --cleaner tacotron \
    --g2p "${g2p}" \
    --train_config "${train_config}" \
    --inference_config "${inference_config}" \
    --train_set "${train_set}" \
    --valid_set "${valid_set}" \
    --test_sets "${test_sets}" \
    --srctexts "data/${train_set}/text" \
    --ngpu "${n_gpus}"\
    --tts_task gan_tts \
    ${opts} "$@"
