#!/bin/bash

mode=melspc_r3
epoch=200epoch

s=bdl
t=slt

../../../tools/venv/bin/python3 \
    ../../../espnet2/bin/vc_inference.py \
    --ngpu 0 \
    --data_path_and_name_and_type dump/raw/${s}_train_no_dev/wav.scp,speech_s,sound \
    --data_path_and_name_and_type dump/raw/${t}_train_no_dev/wav.scp,speech,sound \
    --model_file exp/vtn/$mode/${s}_to_${t}/${epoch}.pth \
    --train_config exp/vtn/$mode/${s}_to_${t}/config.yaml \
    --output_dir exp/vtn/${mode}/${s}_to_${t}/inference_use_teacher_forcing_${epoch}/train_no_dev \
    --vocoder_file none \
    --use_teacher_forcing true

../../../tools/venv/bin/python3 \
    ../../../espnet2/bin/vc_inference.py \
    --ngpu 0 \
    --data_path_and_name_and_type dump/raw/${s}_dev/wav.scp,speech_s,sound \
    --data_path_and_name_and_type dump/raw/${t}_dev/wav.scp,speech,sound \
    --model_file exp/vtn/$mode/${s}_to_${t}/${epoch}.pth \
    --train_config exp/vtn/$mode/${s}_to_${t}/config.yaml \
    --output_dir exp/vtn/${mode}/${s}_to_${t}/inference_use_teacher_forcing_${epoch}/dev \
    --vocoder_file none \
    --use_teacher_forcing true

../../../tools/venv/bin/python3 \
    ../../../espnet2/bin/vc_inference.py \
    --ngpu 0 \
    --data_path_and_name_and_type dump/raw/${s}_eval/wav.scp,speech_s,sound \
    --data_path_and_name_and_type dump/raw/${t}_eval/wav.scp,speech,sound \
    --model_file exp/vtn/$mode/${s}_to_${t}/${epoch}.pth \
    --train_config exp/vtn/$mode/${s}_to_${t}/config.yaml \
    --output_dir exp/vtn/${mode}/${s}_to_${t}/inference_use_teacher_forcing_${epoch}/eval \
    --vocoder_file none \
    --use_teacher_forcing true
